/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <Dialog.h> 


/*------------------------------------------------------------------------------*
 * File Name: TwoGraphDlg.h				 										*
 * Creation: 																	*
 * Purpose: CTwoDialog class									 				*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

 

#include "Graphs.h"      // Resource IDs, in same location as this C file


class C3DScatterDlg : public Dialog
{
public:
	C3DScatterDlg() : Dialog(IDD_TWOGRAPHS, "Graphs")
	{
		
	}
	//virtual 
	int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Dialog::DoModal(hParent);//Launch the dialog
		return nRet;
	}	
	
protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog ) 
	ON_SIZE( OnDlgResize )
	ON_DESTROY( OnDestroy )
EVENTS_END		
	// *** Initialize Dialog on creation ***
	BOOL OnInitDialog()
	{		
		//---- prepare our data for plotting
		int nDataPts = 30;
		m_wks.Create(NULL, CREATE_HIDDEN); m_wks.SetSize(nDataPts, 3); m_wks.SetColDesignations("XYZ");
		Dataset da(m_wks, 0); da.Data(0, nDataPts);
		Dataset db(m_wks, 1); db = sin(da * 10 * 2 * PI / nDataPts);
		Dataset dc(m_wks, 2); dc.Normal(nDataPts); // just noise
		//----
		
		// initialize all data members of interface control
		m_btnOK = GetItem( IDOK );
		
		Control control1 	= GetItem( IDC_TWOGRAPHS_GRAPH1 );
		Control control2 	= GetItem( IDC_TWOGRAPHS_GRAPH2 );
		HWND hWnd1 			=  control1.GetSafeHwnd();
		HWND hWnd2 			=  control2.GetSafeHwnd();
		//Call create control to create graphs, using holder ID and rect
		m_gpControl1.CreateControl(hWnd1);
		m_gpControl2.CreateControl(hWnd2);
		/// end USE_NEWER_APPROACH

		//1. Attemp to attach to an exsiting graph named Graph1 in IDC_TWOGRAPHS_GRAPH1
		GraphPage gp1("Graph1");
		if(gp1)
			m_gpControl1.AttachPage(gp1, NOCLICK_AXES | NOCLICK_TICKLABEL | NOCLICK_LAYERICON | NOCLICK_DATA_PLOT );
		else
			m_gpControl1.Create( NOCLICK_AXES | NOCLICK_TICKLABEL | NOCLICK_LAYERICON | NOCLICK_DATA_PLOT );
		
		plotToGraphControl( m_gpControl1, IDM_PLOT_LINE, 0, 1 );
	
		//2. Attemp to attach to an exsiting graph2 in IDC_TWOGRAPHS_GRAPH2, if not then create our version
		GraphPage gp2("Graph2");
		if(gp2)
			m_gpControl2.AttachPage(gp2, NOCLICK_AXES | NOCLICK_TICKLABEL | NOCLICK_LAYER);
		else
			m_gpControl2.Create( NOCLICK_AXES | NOCLICK_TICKLABEL | NOCLICK_LAYER, "3D" ); // Only disable clicking on axis related objects
		
		plotToGraphControl( m_gpControl2, IDM_PLOT_3D_LINE, 0, 1, 2 );
		return true;
	}
	BOOL OnDestroy()
	{
		m_wks.GetPage().Destroy();
		return true;
	}
		
	// *** Re-size controls on re-sized Dialog ***
	// nType = SIZE_MAXIMIZED, SIZE_RESTORED etc, can be ignored
	// cx and cy are width and height of dialog   
	BOOL OnDlgResize( int nType, int cx, int cy )
	{
		
		// Re-position Close (OK) button
		RECT r1, r2;
		m_btnOK.GetWindowRect( &r1 );
		int nButtonWidth = r1.right - r1.left;
		int nButtonHeight = r1.bottom - r1.top;
		int nCloseButtonGap = nButtonHeight + 3; // Extra 3 pixel from bottom of dialog
		r1.left = cx/2 - nButtonWidth/2;
		r1.right = cx/2 + nButtonWidth/2;
		r1.top = cy - nCloseButtonGap;
		r1.bottom = r1.top + nButtonHeight;
		m_btnOK.MoveWindow( &r1 );	
		
		// Re-size GraphControls
		// Place GraphControls side by side and leave some space for Close button
		int nBottom = cy - nCloseButtonGap - 4; // Extra 4 pixcels between bottom of graph and Close button
		r1.left = 0, r1.top = 0, r1.right = cx / 2 - 1, r1.bottom = nBottom;
		r2.left = cx / 2 + 1, r2.top = 0, r2.right = cx, r2.bottom = nBottom; 
		m_gpControl1.MoveWindow( &r1 );
		m_gpControl2.MoveWindow( &r2 );
		
		return TRUE;
	}
private:
	// *** Add plot to GraphControl ***
	bool plotToGraphControl( GraphControl& ogc, int nPlotType, int nX, int nY, int nZ = -1, bool bRescaleAll = true )
	{
		GraphPage gp = ogc.GetPage(); // Get page
		GraphLayer gl = gp.Layers();  // Get active layer
		string strColX = m_wks.Columns(nX).GetName();
		string strColY = m_wks.Columns(nY).GetName();
		string strColZ;
		if(nZ > nY)
			strColZ = m_wks.Columns(nZ).GetName();
		Tree tr;
		construct_one_data_range(tr, m_wks, strColX, strColY, strColZ, NULL, true);
		DataRange dr;
		dr.Create(tr);
		
		if( gl.AddPlot( dr, nPlotType ) < 0 )   // Plot curve in GraphControl
			return false;
		
		if( bRescaleAll )             // Rescale layer
			gl.Rescale();
		
		return true;
	}
	
private:
	Worksheet		m_wks;
	Button			m_btnOK;		// OK button control
	GraphControl	m_gpControl1;
	GraphControl	m_gpControl2;
};

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
bool test()
{	
	C3DScatterDlg GraphDlg;
	GraphDlg.DoModal( GetWindow() );
	return true;
}
